"""Model for storing email logs when reminders are sent."""

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field


class EmailLog(BaseModel):
    id: Optional[int] = Field(default=None)
    employee_id: Optional[int] = None
    email: str
    subject: str
    body: str
    sent_at: datetime
    status: str = Field(..., description="Status of email sending e.g. SUCCESS/FAILURE")
    error_message: Optional[str] = None

    class Config:
        orm_mode = True